using System.Data;

namespace gov.va.med.vbecs.DAL.VAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>12/22/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Provides means for getting HCPCS codes from VistA via VistALink.</summary>

	#endregion

	public class HcpcsCodes
	{
		private const string HCPCS_CODES_LOOKUP_RPC_NAME = "VBECS HCPCS CODES LOOKUP";

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/19/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8242"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8243"> 
		///		<ExpectedInput>Vista down</ExpectedInput>
		///		<ExpectedOutput>InvalidOperationException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves a list of HCPCS codes by calling 
		/// corresponding VistA RPC via VistALink.
		/// </summary>
		/// <returns><see cref="DataSet"/> containing a list HCPCS codes.</returns>
		public static DataTable GetHcpcsCodes()
		{
			// Try cache table first
			DataSet dsHcpcs = VistaCache.GetHcpcsCache();
			//
			if (dsHcpcs != null && dsHcpcs.Tables.Count > 0 && dsHcpcs.Tables[0].Rows.Count > 0)
			{
				return dsHcpcs.Tables[0];
			}
			else
			{
				string rpcResults = VistALink.GetRpcBroker().ExecuteRpc( VistALink.CreateRpcRequest(HCPCS_CODES_LOOKUP_RPC_NAME) );
				//
				return DataTransformUtility.LoadXmlStringIntoDataSet( rpcResults ).Tables[0];
			}
		}
	}
}
